LoadScript("gallery.lua")

local gGallery = {}
local gWaiting = false
local gScreenshot
local gPreview

-- main
function T_Pictures()
	local taking = false
	while true do
		if PedIsPlaying(gPlayer,"/GLOBAL/WCAMERA/WCAMERA",true) and PedMePlaying(gPlayer,"TAKEPICTURE",true) then
			if not taking then
				if not gWaiting then
					if gScreenshot then
						gScreenshot = nil
						gPreview = nil
						collectgarbage()
					end
					F_TakePicture()
				end
				taking = true
			end
		elseif taking then
			taking = false
		end
		if gScreenshot then
			F_DrawPicture(gPreview)
			
		end
		Wait(0)
	end
end
function T_Sender()
	while true do
		if gScreenshot then
			local typing = StartTyping()
			if CameraGetActive() == 2 then
				CameraReturnToPlayer()
			end
			if typing then
				while IsTypingActive(typing) do
					SetTextFont("Georgia")
					SetTextBold()
					SetTextColor(230,230,230,255)
					SetTextShadow()
					SetTextAlign("C","T")
					SetTextPosition(0.5,0.36)
					DrawText("Upload As: "..GetTypingString(typing).."\n(esc to cancel)")
					Wait(0)
				end
				if not WasTypingAborted(typing) then
					SendNetworkEvent("admin_gallery:Upload",GetTypingString(typing),gScreenshot)
					gWaiting = true -- don't allow another upload until waiting is turned off
				end
				gScreenshot = nil
				gPreview = nil
				collectgarbage()
			end
		end
		Wait(0)
	end
end
function F_TakePicture()
	local texture = --[[CopyTexture(CreateTexture("nyan.png")) or ]]F_TakeScreenshot()
	local screenshot = DumpTextureToString(texture,gCompression,true)
	local length = string.len(screenshot)
	if length <= gMaxSize then
		PrintOutput(string.format("Picture taken! (%s, %d x %d, compression level %d)",F_FormatBytes(length),gResolution[1],gResolution[2],gCompression))
		gScreenshot = screenshot
		gPreview = texture
	else
		PrintError(string.format("Picture failed! (%s > %d KiB)",F_FormatBytes(length),gMaxSize))
	end
	screenshot = nil
	texture = nil
	collectgarbage()
end
function F_TakeScreenshot()
	local resize = 5 / 3
	local target = CreateRenderTarget(GetDisplayResolution())
	DrawBackBufferOntoTarget(target)
	ClearDisplay()
	SetRendererAlphaBlending(false)
	DrawTexture(target,0.5-resize/2,0.5-resize/2,resize,resize,255,255,255,255)
	SetRendererAlphaBlending(true)
	target = nil
	collectgarbage()
	target = CreateRenderTarget(unpack(gResolution))
	DrawBackBufferOntoTarget(target)
	ClearDisplay()
	target = CopyTexture(target)
	collectgarbage()
	return target
end
function F_FormatBytes(bytes)
	local what = 0
	while bytes >= 1024 do
		bytes = bytes / 1024
		what = what + 1
	end
	if what == 0 or what > 3 then
		return bytes.." B"
	end
	return string.format("%.1f %s",bytes,({"KiB","MiB","GiB"})[what])
end

-- draw picture
function F_DrawPicture(texture)
	local x,y = 0.5,0.05 -- x is centered, y is top aligned
	local height = 0.3 -- height of the image (width is automatic)
	local border = 0.002 -- black border applied to all sides
	local width = height * GetTextureDisplayAspectRatio(texture)
	local ar = GetDisplayAspectRatio()
	DrawRectangle(x-width/2-border/ar,y-border,width+(border/ar)*2,height+border*2,0,255,0,255)
	DrawTexture(texture,x-width/2,y,width,height,255,255,255,255)
end

-- f2menu stuff
function CB_F2MenuOpen(f_add)
	f_add({
		name = "Admin Gallery",
		description = "(admin only)\nView pictures left by admins.",
		thread = M_AdminGallery,
	})
end
function M_AdminGallery(parent,selected)
	local menu = parent:submenu(selected.name,"Upload pictures with your camera!")
	while menu:active() do
		for _,image in ipairs(gGallery) do
			if menu:option(image.name) then
				M_EditImage(menu,image)
			elseif menu:hover() then
				F_DrawPicture(image.png)
			end
		end
		menu:draw()
		Wait(0)
	end
end
function M_EditImage(parent,image)
	local menu = parent:submenu(image.name)
	while menu:active() and F_GetByName(image.name) == image do
		if menu:option("Delete",nil,"Delete this image... FOREVER!!! KILL IT!!!") then
			SendNetworkEvent("admin_gallery:Delete",image.name)
		end
		menu:draw()
		Wait(0)
	end
end

-- network events
RegisterNetworkEventHandler("admin_gallery:Download",function(image)
	xpcall(function()
		image.png = CreateTextureFromString(image.png)
		table.insert(gGallery,image)
		table.sort(gGallery,function(a,b)
			return string.lower(a.name) < string.lower(b.name)
		end)
	end,function(message)
		PrintError(message)
	end)
	collectgarbage()
	SendNetworkEvent("admin_gallery:Next")
end)
RegisterNetworkEventHandler("admin_gallery:Remove",function(name)
	local index = 1
	name = string.lower(name)
	while gGallery[index] do
		if string.lower(gGallery[index].name) == name then
			table.remove(gGallery,index)
		else
			index = index + 1
		end
	end
end)
RegisterNetworkEventHandler("admin_gallery:Allow",function()
	if PedGetAmmoCount(gPlayer,426) == 0 then
		GiveAmmoToPlayer(426,1,false)
	end
	HUDPhotographySetColourUpgrade(true)
	RegisterLocalEventHandler("f2menu:Open",CB_F2MenuOpen)
	CreateAdvancedThread("POST_WORLD","T_Pictures")
	CreateThread("T_Sender")
end)
RegisterNetworkEventHandler("admin_gallery:Success",function(name)
	PrintOutput("Uploaded "..name.."!")
end)
RegisterNetworkEventHandler("admin_gallery:Failure",function(reason)
	PrintError("Upload failed, "..reason.."!")
end)
RegisterNetworkEventHandler("admin_gallery:Ready",function()
	gWaiting = false
end)

-- gallery utility
function F_GetByName(name)
	name = string.lower(name)
	for _,image in ipairs(gGallery) do
		if string.lower(image.name) == name then
			return image
		end
	end
end

-- init network stuff
SendNetworkEvent("admin_gallery:Init")
